@extends('layouts.admin')

@section('title', 'Add New KYC Field')

@section('content')
<div class="px-4 py-8">
    <!-- Header -->
    <div class="mb-8">
        <div class="flex items-center justify-between">
            <div>
                <h1 class="text-3xl font-bold text-gray-800 mb-2">
                    <i class="fas fa-plus text-primary mr-3"></i>Add New KYC Field
                </h1>
                <p class="text-gray-600">Create a new field for the KYC form</p>
            </div>
            <a href="{{ route('admin.kyc-form.index') }}" class="bg-gray-600 text-white px-6 py-3 rounded-lg hover:bg-gray-700 transition">
                <i class="fas fa-arrow-left mr-2"></i>Back to Fields
            </a>
        </div>
    </div>

    <!-- Form -->
    <form method="POST" action="{{ route('admin.kyc-form.store') }}" class="bg-white rounded-xl shadow-lg p-8">
        @csrf

        <div class="grid md:grid-cols-2 gap-6">
            <!-- Field Name -->
            <div>
                <label class="block text-sm font-semibold text-gray-700 mb-2">Field Name (Database) *</label>
                <input type="text" name="field_name" value="{{ old('field_name') }}" required
                    class="w-full border-gray-300 rounded-lg px-4 py-3 focus:border-primary focus:ring-2 focus:ring-primary/20"
                    placeholder="e.g., business_email">
                <p class="text-xs text-gray-500 mt-1">Use lowercase with underscores (e.g., business_email)</p>
                @error('field_name')
                    <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                @enderror
            </div>

            <!-- Field Label -->
            <div>
                <label class="block text-sm font-semibold text-gray-700 mb-2">Field Label (Display) *</label>
                <input type="text" name="field_label" value="{{ old('field_label') }}" required
                    class="w-full border-gray-300 rounded-lg px-4 py-3 focus:border-primary focus:ring-2 focus:ring-primary/20"
                    placeholder="e.g., Business Email Address">
                <p class="text-xs text-gray-500 mt-1">This is what users will see</p>
                @error('field_label')
                    <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                @enderror
            </div>

            <!-- Field Type -->
            <div>
                <label class="block text-sm font-semibold text-gray-700 mb-2">Field Type *</label>
                <select name="field_type" id="field_type" required
                    class="w-full border-gray-300 rounded-lg px-4 py-3 focus:border-primary focus:ring-2 focus:ring-primary/20">
                    <option value="">Select field type...</option>
                    <option value="text" {{ old('field_type') === 'text' ? 'selected' : '' }}>Text Input</option>
                    <option value="textarea" {{ old('field_type') === 'textarea' ? 'selected' : '' }}>Textarea</option>
                    <option value="select" {{ old('field_type') === 'select' ? 'selected' : '' }}>Dropdown Select</option>
                    <option value="file" {{ old('field_type') === 'file' ? 'selected' : '' }}>File Upload</option>
                    <option value="number" {{ old('field_type') === 'number' ? 'selected' : '' }}>Number</option>
                    <option value="email" {{ old('field_type') === 'email' ? 'selected' : '' }}>Email</option>
                    <option value="tel" {{ old('field_type') === 'tel' ? 'selected' : '' }}>Phone Number</option>
                </select>
                @error('field_type')
                    <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                @enderror
            </div>

            <!-- Required -->
            <div>
                <label class="block text-sm font-semibold text-gray-700 mb-2">Field Status</label>
                <div class="space-y-2">
                    <label class="flex items-center">
                        <input type="checkbox" name="is_required" value="1" {{ old('is_required') ? 'checked' : '' }}
                            class="rounded border-gray-300 text-primary focus:ring-primary">
                        <span class="ml-2 text-sm text-gray-700">Required Field</span>
                    </label>
                    <label class="flex items-center">
                        <input type="checkbox" name="is_active" value="1" {{ old('is_active', true) ? 'checked' : '' }}
                            class="rounded border-gray-300 text-primary focus:ring-primary">
                        <span class="ml-2 text-sm text-gray-700">Active (Show on form)</span>
                    </label>
                </div>
            </div>

            <!-- Placeholder -->
            <div>
                <label class="block text-sm font-semibold text-gray-700 mb-2">Placeholder Text</label>
                <input type="text" name="placeholder" value="{{ old('placeholder') }}"
                    class="w-full border-gray-300 rounded-lg px-4 py-3 focus:border-primary focus:ring-2 focus:ring-primary/20"
                    placeholder="e.g., Enter your email">
                @error('placeholder')
                    <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                @enderror
            </div>

            <!-- Help Text -->
            <div>
                <label class="block text-sm font-semibold text-gray-700 mb-2">Help Text</label>
                <input type="text" name="help_text" value="{{ old('help_text') }}"
                    class="w-full border-gray-300 rounded-lg px-4 py-3 focus:border-primary focus:ring-2 focus:ring-primary/20"
                    placeholder="e.g., We'll use this for notifications">
                @error('help_text')
                    <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                @enderror
            </div>

            <!-- Validation Rules -->
            <div class="md:col-span-2">
                <label class="block text-sm font-semibold text-gray-700 mb-2">Validation Rules</label>
                <input type="text" name="validation_rules" value="{{ old('validation_rules') }}"
                    class="w-full border-gray-300 rounded-lg px-4 py-3 focus:border-primary focus:ring-2 focus:ring-primary/20"
                    placeholder="e.g., required|email|max:255">
                <p class="text-xs text-gray-500 mt-1">Laravel validation rules (e.g., required|email|max:255)</p>
                @error('validation_rules')
                    <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                @enderror
            </div>

            <!-- Select Options (shown only for select type) -->
            <div id="select-options-container" class="md:col-span-2 hidden">
                <label class="block text-sm font-semibold text-gray-700 mb-2">Select Options</label>
                <div id="options-list" class="space-y-2 mb-2">
                    <!-- Options will be added here dynamically -->
                </div>
                <button type="button" onclick="addOption()" class="bg-green-600 text-white px-4 py-2 rounded-lg hover:bg-green-700 transition text-sm">
                    <i class="fas fa-plus mr-1"></i>Add Option
                </button>
            </div>
        </div>

        <!-- Submit Buttons -->
        <div class="flex gap-4 mt-8 pt-6 border-t">
            <button type="submit" 
                class="flex-1 bg-primary text-white px-8 py-4 rounded-lg hover:bg-primary-dark transition font-bold text-lg">
                <i class="fas fa-save mr-2"></i>Create Field
            </button>
            <a href="{{ route('admin.kyc-form.index') }}" 
                class="flex-1 bg-gray-500 text-white px-8 py-4 rounded-lg hover:bg-gray-600 transition font-bold text-lg text-center">
                <i class="fas fa-times mr-2"></i>Cancel
            </a>
        </div>
    </form>
</div>

@push('scripts')
<script>
    let optionCounter = 0;

    document.getElementById('field_type').addEventListener('change', function() {
        const selectOptionsContainer = document.getElementById('select-options-container');
        if (this.value === 'select') {
            selectOptionsContainer.classList.remove('hidden');
        } else {
            selectOptionsContainer.classList.add('hidden');
        }
    });

    function addOption() {
        const optionsList = document.getElementById('options-list');
        const optionDiv = document.createElement('div');
        optionDiv.className = 'flex gap-2';
        optionDiv.innerHTML = `
            <input type="text" name="field_options[option_${optionCounter}_key]" 
                class="flex-1 border-gray-300 rounded-lg px-4 py-2" placeholder="Option Key (e.g., option1)">
            <input type="text" name="field_options[option_${optionCounter}_value]" 
                class="flex-1 border-gray-300 rounded-lg px-4 py-2" placeholder="Option Label (e.g., Option 1)">
            <button type="button" onclick="this.parentElement.remove()" 
                class="bg-red-600 text-white px-3 py-2 rounded-lg hover:bg-red-700">
                <i class="fas fa-trash"></i>
            </button>
        `;
        optionsList.appendChild(optionDiv);
        optionCounter++;
    }
</script>
@endpush
@endsection
