@extends('layouts.admin')

@section('title', 'House Type Images')

@section('content')
<div class="px-4 py-8">
    <!-- Header -->
    <div class="mb-8">
        <div class="bg-gradient-to-r from-indigo-600 to-indigo-800 text-white rounded-xl shadow-lg p-6">
            <div class="flex items-center justify-between">
                <div>
                    <h1 class="text-3xl font-bold mb-2">
                        <i class="fas fa-home mr-3"></i>House Type Images
                    </h1>
                    <p class="text-indigo-100">Manage banner images for house types on the homepage</p>
                </div>
                <a href="{{ route('admin.house-types.create') }}" 
                    class="bg-white text-indigo-600 px-6 py-3 rounded-lg hover:bg-indigo-50 font-semibold shadow-lg transform hover:scale-105 transition">
                    <i class="fas fa-plus mr-2"></i>Add House Type Image
                </a>
            </div>
        </div>
    </div>

    <!-- Success Message -->
    @if(session('success'))
        <div class="mb-6 bg-green-50 border-l-4 border-green-500 p-4 rounded-lg">
            <div class="flex items-center">
                <i class="fas fa-check-circle text-green-500 text-xl mr-3"></i>
                <p class="text-green-700 font-semibold">{{ session('success') }}</p>
            </div>
        </div>
    @endif

    <!-- House Types List -->
    <div class="bg-white rounded-xl shadow-lg overflow-hidden">
        @if($houseTypeImages->count() > 0)
            <div class="overflow-x-auto">
                <table class="w-full">
                    <thead class="bg-gray-50 border-b-2 border-gray-200">
                        <tr>
                            <th class="px-6 py-4 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">Image</th>
                            <th class="px-6 py-4 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">House Type</th>
                            <th class="px-6 py-4 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">Description</th>
                            <th class="px-6 py-4 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">Properties</th>
                            <th class="px-6 py-4 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">Status</th>
                            <th class="px-6 py-4 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">Actions</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-200">
                        @foreach($houseTypeImages as $houseType)
                            <tr class="hover:bg-gray-50 transition">
                                <td class="px-6 py-4">
                                    <img src="{{ asset('storage/' . $houseType->image) }}" 
                                        alt="{{ $houseType->house_type }}" 
                                        class="w-32 h-20 object-cover rounded-lg shadow">
                                </td>
                                <td class="px-6 py-4">
                                    <div class="font-semibold text-gray-900">{{ $houseType->house_type }}</div>
                                </td>
                                <td class="px-6 py-4">
                                    <div class="text-sm text-gray-600">
                                        {{ $houseType->description ? Str::limit($houseType->description, 50) : '-' }}
                                    </div>
                                </td>
                                <td class="px-6 py-4">
                                    <span class="inline-flex items-center px-3 py-1 bg-indigo-100 text-indigo-800 rounded-full text-sm font-semibold">
                                        <i class="fas fa-home mr-2"></i>
                                        {{ $houseType->property_count }}
                                    </span>
                                </td>
                                <td class="px-6 py-4">
                                    @if($houseType->active)
                                        <span class="px-3 py-1 bg-green-100 text-green-800 rounded-full text-xs font-semibold">
                                            <i class="fas fa-check-circle mr-1"></i>Active
                                        </span>
                                    @else
                                        <span class="px-3 py-1 bg-gray-100 text-gray-800 rounded-full text-xs font-semibold">
                                            <i class="fas fa-times-circle mr-1"></i>Inactive
                                        </span>
                                    @endif
                                </td>
                                <td class="px-6 py-4">
                                    <div class="flex items-center space-x-2">
                                        <a href="{{ route('properties.index', ['house_type' => $houseType->house_type]) }}" 
                                            target="_blank"
                                            class="text-indigo-600 hover:text-indigo-800 transition"
                                            title="View Properties">
                                            <i class="fas fa-external-link-alt"></i>
                                        </a>
                                        <a href="{{ route('admin.house-types.edit', $houseType) }}" 
                                            class="text-blue-600 hover:text-blue-800 transition"
                                            title="Edit">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        <form method="POST" 
                                            action="{{ route('admin.house-types.destroy', $houseType) }}" 
                                            onsubmit="return confirm('Are you sure you want to delete this house type image?');"
                                            class="inline">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" 
                                                class="text-red-600 hover:text-red-800 transition"
                                                title="Delete">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>

            <!-- Pagination -->
            <div class="px-6 py-4 border-t border-gray-200">
                {{ $houseTypeImages->links() }}
            </div>
        @else
            <div class="text-center py-12">
                <i class="fas fa-home text-gray-300 text-6xl mb-4"></i>
                <p class="text-gray-500 text-lg mb-4">No house type images yet</p>
                <a href="{{ route('admin.house-types.create') }}" 
                    class="inline-block bg-indigo-600 text-white px-6 py-3 rounded-lg hover:bg-indigo-700 font-semibold">
                    <i class="fas fa-plus mr-2"></i>Add Your First House Type Image
                </a>
            </div>
        @endif
    </div>

    <!-- Available House Types Info -->
    @if($existingTypes->count() > 0)
        <div class="mt-6 bg-blue-50 border-l-4 border-blue-500 p-4 rounded-lg">
            <div class="flex items-start">
                <i class="fas fa-info-circle text-blue-600 text-xl mr-3 mt-1"></i>
                <div>
                    <h4 class="font-semibold text-blue-900 mb-2">Available House Types in System:</h4>
                    <div class="flex flex-wrap gap-2">
                        @foreach($existingTypes as $type)
                            <span class="px-3 py-1 bg-blue-100 text-blue-800 rounded-full text-sm">
                                {{ $type }}
                            </span>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    @endif
</div>
@endsection
