@extends('layouts.admin')

@section('title', 'Edit Discount Deal')

@section('content')
<div class="container mx-auto px-4 py-8 max-w-4xl">
    <!-- Header -->
    <div class="mb-6">
        <a href="{{ route('admin.discount-deals.index') }}" class="text-primary hover:underline mb-2 inline-block">
            <i class="fas fa-arrow-left mr-2"></i>Back to Discount Deals
        </a>
        <h1 class="text-3xl font-bold text-secondary">Edit Discount Deal</h1>
        <p class="text-gray-600 mt-1">Update discount deal: <span class="font-mono font-bold">{{ $discountDeal->code }}</span></p>
    </div>

    @if($errors->any())
        <div class="bg-red-100 border-l-4 border-red-500 text-red-700 p-4 mb-6 rounded">
            <p class="font-bold mb-2">Please fix the following errors:</p>
            <ul class="list-disc list-inside">
                @foreach($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <!-- Usage Stats -->
    <div class="bg-blue-50 border-l-4 border-blue-500 p-4 mb-6 rounded">
        <div class="flex items-center">
            <i class="fas fa-info-circle text-blue-500 mr-3"></i>
            <div>
                <p class="font-semibold text-blue-900">Usage Statistics</p>
                <p class="text-sm text-blue-700">
                    This code has been used <strong>{{ $discountDeal->usage_count }}</strong> time(s)
                    @if($discountDeal->usage_limit)
                        out of {{ $discountDeal->usage_limit }} allowed
                    @endif
                </p>
            </div>
        </div>
    </div>

    <form action="{{ route('admin.discount-deals.update', $discountDeal) }}" method="POST" class="bg-white rounded-lg shadow-md p-6">
        @csrf
        @method('PUT')

        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
            <!-- Name -->
            <div class="md:col-span-2">
                <label for="name" class="block text-sm font-medium text-gray-700 mb-2">
                    Deal Name <span class="text-red-500">*</span>
                </label>
                <input type="text" name="name" id="name" value="{{ old('name', $discountDeal->name) }}" required
                    class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary focus:border-transparent"
                    placeholder="e.g., Weekend Special Offer">
            </div>

            <!-- Code -->
            <div>
                <label for="code" class="block text-sm font-medium text-gray-700 mb-2">
                    Discount Code <span class="text-red-500">*</span>
                </label>
                <input type="text" name="code" id="code" value="{{ old('code', $discountDeal->code) }}" required
                    class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary focus:border-transparent uppercase"
                    placeholder="e.g., WEEKEND20" style="text-transform: uppercase;">
                <p class="text-xs text-gray-500 mt-1">Letters, numbers, dashes and underscores only</p>
            </div>

            <!-- Discount Type -->
            <div>
                <label for="discount_type" class="block text-sm font-medium text-gray-700 mb-2">
                    Discount Type <span class="text-red-500">*</span>
                </label>
                <select name="discount_type" id="discount_type" required
                    class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary focus:border-transparent">
                    <option value="percentage" {{ old('discount_type', $discountDeal->discount_type) == 'percentage' ? 'selected' : '' }}>Percentage (%)</option>
                    <option value="fixed" {{ old('discount_type', $discountDeal->discount_type) == 'fixed' ? 'selected' : '' }}>Fixed Amount (₦)</option>
                </select>
            </div>

            <!-- Discount Value -->
            <div>
                <label for="discount_value" class="block text-sm font-medium text-gray-700 mb-2">
                    Discount Value <span class="text-red-500">*</span>
                </label>
                <input type="number" name="discount_value" id="discount_value" value="{{ old('discount_value', $discountDeal->discount_value) }}" 
                    step="0.01" min="0" required
                    class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary focus:border-transparent"
                    placeholder="e.g., 20 or 3000">
                <p class="text-xs text-gray-500 mt-1" id="discount_hint">
                    {{ $discountDeal->discount_type === 'percentage' ? 'Enter percentage value (0-100)' : 'Enter fixed amount in Naira' }}
                </p>
            </div>

            <!-- Max Discount Amount -->
            <div>
                <label for="max_discount_amount" class="block text-sm font-medium text-gray-700 mb-2">
                    Max Discount Amount (₦)
                </label>
                <input type="number" name="max_discount_amount" id="max_discount_amount" value="{{ old('max_discount_amount', $discountDeal->max_discount_amount) }}" 
                    step="0.01" min="0"
                    class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary focus:border-transparent"
                    placeholder="Optional - for percentage discounts">
                <p class="text-xs text-gray-500 mt-1">Cap the maximum discount for percentage type</p>
            </div>

            <!-- Min Booking Amount -->
            <div>
                <label for="min_booking_amount" class="block text-sm font-medium text-gray-700 mb-2">
                    Minimum Booking Amount (₦) <span class="text-red-500">*</span>
                </label>
                <input type="number" name="min_booking_amount" id="min_booking_amount" value="{{ old('min_booking_amount', $discountDeal->min_booking_amount) }}" 
                    step="0.01" min="0" required
                    class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary focus:border-transparent"
                    placeholder="0">
                <p class="text-xs text-gray-500 mt-1">Minimum booking amount required to use this code</p>
            </div>

            <!-- Usage Limit -->
            <div>
                <label for="usage_limit" class="block text-sm font-medium text-gray-700 mb-2">
                    Total Usage Limit
                </label>
                <input type="number" name="usage_limit" id="usage_limit" value="{{ old('usage_limit', $discountDeal->usage_limit) }}" 
                    min="1"
                    class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary focus:border-transparent"
                    placeholder="Leave empty for unlimited">
                <p class="text-xs text-gray-500 mt-1">Total number of times this code can be used</p>
            </div>

            <!-- Usage Per User -->
            <div>
                <label for="usage_per_user" class="block text-sm font-medium text-gray-700 mb-2">
                    Usage Per User <span class="text-red-500">*</span>
                </label>
                <input type="number" name="usage_per_user" id="usage_per_user" value="{{ old('usage_per_user', $discountDeal->usage_per_user) }}" 
                    min="1" required
                    class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary focus:border-transparent"
                    placeholder="1">
                <p class="text-xs text-gray-500 mt-1">How many times each user can use this code</p>
            </div>

            <!-- Valid From -->
            <div>
                <label for="valid_from" class="block text-sm font-medium text-gray-700 mb-2">
                    Valid From
                </label>
                <input type="datetime-local" name="valid_from" id="valid_from" 
                    value="{{ old('valid_from', $discountDeal->valid_from ? $discountDeal->valid_from->format('Y-m-d\TH:i') : '') }}"
                    class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary focus:border-transparent">
                <p class="text-xs text-gray-500 mt-1">Leave empty to start immediately</p>
            </div>

            <!-- Valid Until -->
            <div>
                <label for="valid_until" class="block text-sm font-medium text-gray-700 mb-2">
                    Valid Until
                </label>
                <input type="datetime-local" name="valid_until" id="valid_until" 
                    value="{{ old('valid_until', $discountDeal->valid_until ? $discountDeal->valid_until->format('Y-m-d\TH:i') : '') }}"
                    class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary focus:border-transparent">
                <p class="text-xs text-gray-500 mt-1">Leave empty for no expiry</p>
            </div>

            <!-- Description -->
            <div class="md:col-span-2">
                <label for="description" class="block text-sm font-medium text-gray-700 mb-2">
                    Description
                </label>
                <textarea name="description" id="description" rows="3"
                    class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary focus:border-transparent"
                    placeholder="Optional description for internal reference">{{ old('description', $discountDeal->description) }}</textarea>
            </div>

            <!-- Is Active & Featured -->
            <div class="md:col-span-2">
                <label class="flex items-center mb-3">
                    <input type="checkbox" name="is_active" value="1" {{ old('is_active', $discountDeal->is_active) ? 'checked' : '' }}
                        class="w-4 h-4 text-primary border-gray-300 rounded focus:ring-primary">
                    <span class="ml-2 text-sm text-gray-700">Active (code can be used immediately)</span>
                </label>
                
                <label class="flex items-center">
                    <input type="checkbox" name="is_featured" value="1" {{ old('is_featured', $discountDeal->is_featured) ? 'checked' : '' }}
                        class="w-4 h-4 text-primary border-gray-300 rounded focus:ring-primary">
                    <span class="ml-2 text-sm text-gray-700">
                        <i class="fas fa-star text-yellow-500"></i> Featured (show on homepage)
                    </span>
                </label>
            </div>
        </div>

        <!-- Homepage Banner Settings -->
        <div class="mt-8 pt-8 border-t">
            <div class="mb-6">
                <label class="flex items-center mb-4">
                    <input type="checkbox" name="show_on_homepage" id="show_on_homepage" value="1" {{ old('show_on_homepage', $discountDeal->show_on_homepage) ? 'checked' : '' }}
                        class="w-4 h-4 text-primary border-gray-300 rounded focus:ring-primary">
                    <span class="ml-2 text-sm font-semibold text-gray-700">
                        <i class="fas fa-bullhorn text-primary"></i> Show as Homepage Banner
                    </span>
                </label>
                <p class="text-xs text-gray-500 ml-6">Display this discount as a promotional banner on the homepage</p>
            </div>

            <div id="banner-settings" class="grid grid-cols-1 md:grid-cols-2 gap-6" style="display: none;">
                <!-- Banner Title -->
                <div class="md:col-span-2">
                    <label for="banner_title" class="block text-sm font-medium text-gray-700 mb-2">
                        Banner Title
                    </label>
                    <input type="text" name="banner_title" id="banner_title" value="{{ old('banner_title', $discountDeal->banner_title) }}"
                        class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary focus:border-transparent"
                        placeholder="e.g., Weekend Special! 🎉 (leave empty to use deal name)">
                </div>

                <!-- Banner Description -->
                <div class="md:col-span-2">
                    <label for="banner_description" class="block text-sm font-medium text-gray-700 mb-2">
                        Banner Description
                    </label>
                    <textarea name="banner_description" id="banner_description" rows="2"
                        class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary focus:border-transparent"
                        placeholder="e.g., Get up to 25% OFF on weekend bookings">{{ old('banner_description', $discountDeal->banner_description) }}</textarea>
                </div>

                <!-- Button Text -->
                <div>
                    <label for="banner_button_text" class="block text-sm font-medium text-gray-700 mb-2">
                        Button Text
                    </label>
                    <input type="text" name="banner_button_text" id="banner_button_text" value="{{ old('banner_button_text', $discountDeal->banner_button_text ?? 'Browse Deals') }}"
                        class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary focus:border-transparent">
                </div>

                <!-- Button Link -->
                <div>
                    <label for="banner_button_link" class="block text-sm font-medium text-gray-700 mb-2">
                        Button Link
                    </label>
                    <input type="text" name="banner_button_link" id="banner_button_link" value="{{ old('banner_button_link', $discountDeal->banner_button_link ?? '/properties') }}"
                        class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary focus:border-transparent">
                </div>

                <!-- Background Gradient Colors -->
                <div>
                    <label for="banner_bg_from" class="block text-sm font-medium text-gray-700 mb-2">
                        Background Color (From)
                    </label>
                    <select name="banner_bg_from" id="banner_bg_from"
                        class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary focus:border-transparent">
                        <option value="orange-500" {{ old('banner_bg_from', $discountDeal->banner_bg_from) == 'orange-500' ? 'selected' : '' }}>Orange</option>
                        <option value="red-500" {{ old('banner_bg_from', $discountDeal->banner_bg_from) == 'red-500' ? 'selected' : '' }}>Red</option>
                        <option value="purple-600" {{ old('banner_bg_from', $discountDeal->banner_bg_from) == 'purple-600' ? 'selected' : '' }}>Purple</option>
                        <option value="blue-600" {{ old('banner_bg_from', $discountDeal->banner_bg_from) == 'blue-600' ? 'selected' : '' }}>Blue</option>
                        <option value="cyan-500" {{ old('banner_bg_from', $discountDeal->banner_bg_from) == 'cyan-500' ? 'selected' : '' }}>Cyan</option>
                        <option value="green-500" {{ old('banner_bg_from', $discountDeal->banner_bg_from) == 'green-500' ? 'selected' : '' }}>Green</option>
                        <option value="pink-500" {{ old('banner_bg_from', $discountDeal->banner_bg_from) == 'pink-500' ? 'selected' : '' }}>Pink</option>
                        <option value="yellow-500" {{ old('banner_bg_from', $discountDeal->banner_bg_from) == 'yellow-500' ? 'selected' : '' }}>Yellow</option>
                    </select>
                </div>

                <div>
                    <label for="banner_bg_to" class="block text-sm font-medium text-gray-700 mb-2">
                        Background Color (To)
                    </label>
                    <select name="banner_bg_to" id="banner_bg_to"
                        class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary focus:border-transparent">
                        <option value="red-500" {{ old('banner_bg_to', $discountDeal->banner_bg_to) == 'red-500' ? 'selected' : '' }}>Red</option>
                        <option value="orange-500" {{ old('banner_bg_to', $discountDeal->banner_bg_to) == 'orange-500' ? 'selected' : '' }}>Orange</option>
                        <option value="blue-600" {{ old('banner_bg_to', $discountDeal->banner_bg_to) == 'blue-600' ? 'selected' : '' }}>Blue</option>
                        <option value="purple-600" {{ old('banner_bg_to', $discountDeal->banner_bg_to) == 'purple-600' ? 'selected' : '' }}>Purple</option>
                        <option value="cyan-500" {{ old('banner_bg_to', $discountDeal->banner_bg_to) == 'cyan-500' ? 'selected' : '' }}>Cyan</option>
                        <option value="teal-500" {{ old('banner_bg_to', $discountDeal->banner_bg_to) == 'teal-500' ? 'selected' : '' }}>Teal</option>
                        <option value="green-500" {{ old('banner_bg_to', $discountDeal->banner_bg_to) == 'green-500' ? 'selected' : '' }}>Green</option>
                        <option value="pink-500" {{ old('banner_bg_to', $discountDeal->banner_bg_to) == 'pink-500' ? 'selected' : '' }}>Pink</option>
                    </select>
                </div>

                <!-- Icon -->
                <div class="md:col-span-2">
                    <label for="banner_icon" class="block text-sm font-medium text-gray-700 mb-2">
                        Icon (FontAwesome)
                    </label>
                    <select name="banner_icon" id="banner_icon"
                        class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary focus:border-transparent">
                        <option value="gift" {{ old('banner_icon', $discountDeal->banner_icon) == 'gift' ? 'selected' : '' }}>🎁 Gift</option>
                        <option value="star" {{ old('banner_icon', $discountDeal->banner_icon) == 'star' ? 'selected' : '' }}>⭐ Star</option>
                        <option value="fire" {{ old('banner_icon', $discountDeal->banner_icon) == 'fire' ? 'selected' : '' }}>🔥 Fire</option>
                        <option value="bolt" {{ old('banner_icon', $discountDeal->banner_icon) == 'bolt' ? 'selected' : '' }}>⚡ Lightning</option>
                        <option value="heart" {{ old('banner_icon', $discountDeal->banner_icon) == 'heart' ? 'selected' : '' }}>❤️ Heart</option>
                        <option value="tags" {{ old('banner_icon', $discountDeal->banner_icon) == 'tags' ? 'selected' : '' }}>🏷️ Tags</option>
                        <option value="percent" {{ old('banner_icon', $discountDeal->banner_icon) == 'percent' ? 'selected' : '' }}>% Percent</option>
                        <option value="umbrella-beach" {{ old('banner_icon', $discountDeal->banner_icon) == 'umbrella-beach' ? 'selected' : '' }}>🏖️ Beach</option>
                        <option value="plane" {{ old('banner_icon', $discountDeal->banner_icon) == 'plane' ? 'selected' : '' }}>✈️ Plane</option>
                        <option value="sparkles" {{ old('banner_icon', $discountDeal->banner_icon) == 'sparkles' ? 'selected' : '' }}>✨ Sparkles</option>
                    </select>
                </div>
            </div>
        </div>

        <!-- Submit Buttons -->
        <div class="flex justify-end space-x-4 mt-8 pt-6 border-t">
            <a href="{{ route('admin.discount-deals.index') }}" 
                class="px-6 py-2 border border-gray-300 rounded-lg text-gray-700 hover:bg-gray-50 transition">
                Cancel
            </a>
            <button type="submit" 
                class="px-6 py-2 bg-primary text-white rounded-lg hover:bg-primary-dark transition">
                <i class="fas fa-save mr-2"></i>Update Discount Deal
            </button>
        </div>
    </form>
</div>

<script>
document.getElementById('discount_type').addEventListener('change', function() {
    const hint = document.getElementById('discount_hint');
    if (this.value === 'percentage') {
        hint.textContent = 'Enter percentage value (0-100)';
    } else {
        hint.textContent = 'Enter fixed amount in Naira';
    }
});

// Toggle banner settings visibility
document.getElementById('show_on_homepage').addEventListener('change', function() {
    const bannerSettings = document.getElementById('banner-settings');
    if (this.checked) {
        bannerSettings.style.display = 'grid';
    } else {
        bannerSettings.style.display = 'none';
    }
});

// Show banner settings if checkbox is already checked (for existing data or old() values)
if (document.getElementById('show_on_homepage').checked) {
    document.getElementById('banner-settings').style.display = 'grid';
}
</script>
@endsection
