@extends('layouts.admin')

@section('title', 'Popular Destinations')

@section('content')
<div class="px-4 py-8">
    <!-- Header -->
    <div class="mb-8">
        <div class="bg-gradient-to-r from-purple-600 to-purple-800 text-white rounded-xl shadow-lg p-6">
            <div class="flex items-center justify-between">
                <div>
                    <h1 class="text-3xl font-bold mb-2">
                        <i class="fas fa-map-marked-alt mr-3"></i>Popular Destinations
                    </h1>
                    <p class="text-purple-100">Manage featured cities and states on the homepage</p>
                </div>
                <a href="{{ route('admin.destinations.create') }}" 
                    class="bg-white text-purple-600 px-6 py-3 rounded-lg hover:bg-purple-50 font-semibold shadow-lg transform hover:scale-105 transition">
                    <i class="fas fa-plus mr-2"></i>Add Destination
                </a>
            </div>
        </div>
    </div>

    <!-- Success Message -->
    @if(session('success'))
        <div class="mb-6 bg-green-50 border-l-4 border-green-500 p-4 rounded-lg">
            <div class="flex items-center">
                <i class="fas fa-check-circle text-green-500 text-xl mr-3"></i>
                <p class="text-green-700 font-semibold">{{ session('success') }}</p>
            </div>
        </div>
    @endif

    <!-- Destinations List -->
    <div class="bg-white rounded-xl shadow-lg overflow-hidden">
        @if($destinations->count() > 0)
            <div class="overflow-x-auto">
                <table class="w-full">
                    <thead class="bg-gray-50 border-b-2 border-gray-200">
                        <tr>
                            <th class="px-6 py-4 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">Image</th>
                            <th class="px-6 py-4 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">Name</th>
                            <th class="px-6 py-4 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">Type</th>
                            <th class="px-6 py-4 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">State</th>
                            <th class="px-6 py-4 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">Properties</th>
                            <th class="px-6 py-4 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">Order</th>
                            <th class="px-6 py-4 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">Status</th>
                            <th class="px-6 py-4 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">Actions</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-200">
                        @foreach($destinations as $destination)
                            <tr class="hover:bg-gray-50 transition">
                                <td class="px-6 py-4">
                                    <img src="{{ asset('storage/' . $destination->image) }}" 
                                        alt="{{ $destination->name }}" 
                                        class="w-20 h-20 object-cover rounded-lg shadow">
                                </td>
                                <td class="px-6 py-4">
                                    <div class="font-semibold text-gray-900">{{ $destination->name }}</div>
                                    @if($destination->description)
                                        <div class="text-sm text-gray-500 mt-1">{{ Str::limit($destination->description, 50) }}</div>
                                    @endif
                                </td>
                                <td class="px-6 py-4">
                                    <span class="px-3 py-1 rounded-full text-xs font-semibold
                                        {{ $destination->type === 'state' ? 'bg-blue-100 text-blue-800' : 'bg-green-100 text-green-800' }}">
                                        <i class="fas fa-{{ $destination->type === 'state' ? 'flag' : 'city' }} mr-1"></i>
                                        {{ ucfirst($destination->type) }}
                                    </span>
                                </td>
                                <td class="px-6 py-4 text-gray-700">
                                    {{ $destination->state ?? '-' }}
                                </td>
                                <td class="px-6 py-4">
                                    <span class="inline-flex items-center px-3 py-1 bg-purple-100 text-purple-800 rounded-full text-sm font-semibold">
                                        <i class="fas fa-home mr-2"></i>
                                        {{ $destination->property_count }}
                                    </span>
                                </td>
                                <td class="px-6 py-4">
                                    <span class="text-gray-700 font-medium">{{ $destination->display_order }}</span>
                                </td>
                                <td class="px-6 py-4">
                                    @if($destination->active)
                                        <span class="px-3 py-1 bg-green-100 text-green-800 rounded-full text-xs font-semibold">
                                            <i class="fas fa-check-circle mr-1"></i>Active
                                        </span>
                                    @else
                                        <span class="px-3 py-1 bg-gray-100 text-gray-800 rounded-full text-xs font-semibold">
                                            <i class="fas fa-times-circle mr-1"></i>Inactive
                                        </span>
                                    @endif
                                </td>
                                <td class="px-6 py-4">
                                    <div class="flex items-center space-x-2">
                                        <a href="{{ $destination->url }}" 
                                            target="_blank"
                                            class="text-purple-600 hover:text-purple-800 transition"
                                            title="View Properties">
                                            <i class="fas fa-external-link-alt"></i>
                                        </a>
                                        <a href="{{ route('admin.destinations.edit', $destination) }}" 
                                            class="text-blue-600 hover:text-blue-800 transition"
                                            title="Edit">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        <form method="POST" 
                                            action="{{ route('admin.destinations.destroy', $destination) }}" 
                                            onsubmit="return confirm('Are you sure you want to delete this destination?');"
                                            class="inline">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" 
                                                class="text-red-600 hover:text-red-800 transition"
                                                title="Delete">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>

            <!-- Pagination -->
            <div class="px-6 py-4 border-t border-gray-200">
                {{ $destinations->links() }}
            </div>
        @else
            <div class="text-center py-12">
                <i class="fas fa-map-marked-alt text-gray-300 text-6xl mb-4"></i>
                <p class="text-gray-500 text-lg mb-4">No popular destinations yet</p>
                <a href="{{ route('admin.destinations.create') }}" 
                    class="inline-block bg-purple-600 text-white px-6 py-3 rounded-lg hover:bg-purple-700 font-semibold">
                    <i class="fas fa-plus mr-2"></i>Add Your First Destination
                </a>
            </div>
        @endif
    </div>
</div>
@endsection
