@extends('layouts.admin')

@section('title', 'Admin Dashboard')

@section('content')
<div>
    <h1 class="text-3xl font-bold mb-6">Dashboard Overview</h1>

    <!-- Stats Cards -->
    <div class="grid md:grid-cols-4 gap-6 mb-8">
        <div class="bg-white rounded-lg shadow-md p-6">
            <div class="flex items-center justify-between mb-2">
                <p class="text-gray-600">Total Users</p>
                <i class="fas fa-users text-primary text-2xl"></i>
            </div>
            <p class="text-3xl font-bold">{{ number_format($stats['total_users']) }}</p>
        </div>

        <div class="bg-white rounded-lg shadow-md p-6">
            <div class="flex items-center justify-between mb-2">
                <p class="text-gray-600">Active Vendors</p>
                <i class="fas fa-store text-green-500 text-2xl"></i>
            </div>
            <p class="text-3xl font-bold">{{ number_format($stats['active_vendors']) }}</p>
            <p class="text-sm text-gray-500">of {{ $stats['total_vendors'] }} total</p>
        </div>

        <div class="bg-white rounded-lg shadow-md p-6">
            <div class="flex items-center justify-between mb-2">
                <p class="text-gray-600">Total Revenue</p>
                <i class="fas fa-money-bill-wave text-primary text-2xl"></i>
            </div>
            <p class="text-3xl font-bold">₦{{ number_format($stats['total_revenue']) }}</p>
        </div>

        <div class="bg-white rounded-lg shadow-md p-6">
            <div class="flex items-center justify-between mb-2">
                <p class="text-gray-600">Total Commission Earned</p>
                <i class="fas fa-chart-line text-yellow-500 text-2xl"></i>
            </div>
            <p class="text-3xl font-bold mb-3">₦{{ number_format($stats['total_commission']) }}</p>
            
            <!-- Commission Breakdown -->
            <div class="grid grid-cols-2 gap-3 mt-4 pt-4 border-t">
                <div class="bg-blue-50 rounded-lg p-3">
                    <p class="text-xs text-blue-600 mb-1">Property Commission</p>
                    <p class="text-lg font-bold text-blue-700">₦{{ number_format($stats['property_commission']) }}</p>
                </div>
                <div class="bg-green-50 rounded-lg p-3">
                    <p class="text-xs text-green-600 mb-1">Car Rental Commission</p>
                    <p class="text-lg font-bold text-green-700">₦{{ number_format($stats['car_commission']) }}</p>
                </div>
            </div>
        </div>
    </div>

    <!-- Action Items -->
    <div class="grid md:grid-cols-2 gap-6 mb-8">
        <!-- Pending Payment Verifications -->
        <div class="bg-white rounded-lg shadow-md p-6">
            <div class="flex justify-between items-center mb-4">
                <h2 class="font-bold text-xl">Pending Payment Verifications</h2>
                <span class="bg-yellow-100 text-yellow-800 px-3 py-1 rounded-full text-sm font-semibold">
                    {{ $pendingVerifications->count() }}
                </span>
            </div>

            @forelse($pendingVerifications as $booking)
                <div class="border-b last:border-b-0 py-3">
                    <div class="flex justify-between items-start">
                        <div>
                            <p class="font-semibold">{{ $booking->property->title }}</p>
                            <p class="text-sm text-gray-600">{{ $booking->user->name }}</p>
                            <p class="text-sm text-gray-500">₦{{ number_format($booking->total_amount) }}</p>
                        </div>
                        <a href="{{ route('admin.bookings.show', $booking) }}" 
                            class="text-primary hover:underline text-sm">Verify</a>
                    </div>
                </div>
            @empty
                <p class="text-gray-600 text-center py-4">No pending verifications</p>
            @endforelse
        </div>

        <!-- Pending Ad Approvals -->
        <div class="bg-white rounded-lg shadow-md p-6">
            <div class="flex justify-between items-center mb-4">
                <h2 class="font-bold text-xl">Pending Ad Approvals</h2>
                <span class="bg-primary/10 text-purple-800 px-3 py-1 rounded-full text-sm font-semibold">
                    {{ $stats['pending_ad_approvals'] }}
                </span>
            </div>

            <div class="text-center py-4">
                <a href="{{ route('admin.ads.index') }}" 
                    class="text-primary hover:underline">View Ad Approvals →</a>
            </div>
        </div>
    </div>

    <!-- Recent Bookings -->
    <div class="bg-white rounded-lg shadow-md p-6">
        <h2 class="font-bold text-xl mb-4">Recent Bookings</h2>
        
        <div class="overflow-x-auto">
            <table class="w-full">
                <thead class="bg-light-bg">
                    <tr>
                        <th class="px-4 py-2 text-left">ID</th>
                        <th class="px-4 py-2 text-left">Guest</th>
                        <th class="px-4 py-2 text-left">Property</th>
                        <th class="px-4 py-2 text-left">Dates</th>
                        <th class="px-4 py-2 text-left">Amount</th>
                        <th class="px-4 py-2 text-left">Status</th>
                        <th class="px-4 py-2 text-left">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($recentBookings as $booking)
                        <tr class="border-b">
                            <td class="px-4 py-3">#{{ $booking->id }}</td>
                            <td class="px-4 py-3">{{ $booking->user->name }}</td>
                            <td class="px-4 py-3">{{ Str::limit($booking->property->title, 30) }}</td>
                            <td class="px-4 py-3">{{ $booking->start_date->format('M d') }} - {{ $booking->end_date->format('M d') }}</td>
                            <td class="px-4 py-3">₦{{ number_format($booking->total_amount) }}</td>
                            <td class="px-4 py-3">
                                <span class="px-2 py-1 rounded-full text-xs
                                    @if($booking->booking_status === 'confirmed') bg-green-100 text-green-800
                                    @elseif($booking->booking_status === 'pending') bg-yellow-100 text-yellow-800
                                    @else bg-gray-100 text-secondary
                                    @endif">
                                    {{ ucfirst($booking->booking_status) }}
                                </span>
                            </td>
                            <td class="px-4 py-3">
                                <a href="{{ route('admin.bookings.show', $booking) }}" 
                                    class="text-primary hover:underline">View</a>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="7" class="text-center py-8 text-gray-600">No bookings yet</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
</div>
@endsection