@extends('layouts.admin')

@section('title', 'Audit Logs')

@section('content')
<div>
    <h1 class="text-3xl font-bold mb-6">Audit Logs</h1>

    <!-- Filters -->
    <div class="bg-white rounded-lg shadow-md p-6 mb-6">
        <form method="GET" class="grid md:grid-cols-5 gap-4">
            <select name="actor_role" class="border rounded px-4 py-2">
                <option value="">All Roles</option>
                <option value="owner" {{ request('actor_role') === 'owner' ? 'selected' : '' }}>Owner</option>
                <option value="manager" {{ request('actor_role') === 'manager' ? 'selected' : '' }}>Manager</option>
                <option value="moderator" {{ request('actor_role') === 'moderator' ? 'selected' : '' }}>Moderator</option>
            </select>

            <input type="text" name="action_type" placeholder="Action type" 
                value="{{ request('action_type') }}" class="border rounded px-4 py-2">

            <input type="date" name="date_from" value="{{ request('date_from') }}" 
                class="border rounded px-4 py-2">

            <input type="date" name="date_to" value="{{ request('date_to') }}" 
                class="border rounded px-4 py-2">

            <button type="submit" class="bg-primary text-white px-4 py-2 rounded hover:bg-primary-dark">
                Filter
            </button>
        </form>
    </div>

    <!-- Logs Table -->
    <div class="bg-white rounded-lg shadow-md overflow-hidden">
        <table class="w-full">
            <thead class="bg-light-bg">
                <tr>
                    <th class="px-4 py-3 text-left">Timestamp</th>
                    <th class="px-4 py-3 text-left">Actor</th>
                    <th class="px-4 py-3 text-left">Role</th>
                    <th class="px-4 py-3 text-left">Action</th>
                    <th class="px-4 py-3 text-left">Subject</th>
                    <th class="px-4 py-3 text-left">Description</th>
                    <th class="px-4 py-3 text-left">IP</th>
                </tr>
            </thead>
            <tbody>
                @forelse($logs as $log)
                    <tr class="border-b hover:bg-light-bg">
                        <td class="px-4 py-3 text-sm">{{ $log->created_at->format('M d, Y H:i') }}</td>
                        <td class="px-4 py-3">{{ $log->actor?->name ?? 'System' }}</td>
                        <td class="px-4 py-3">
                            <span class="px-2 py-1 rounded-full text-xs
                                @if($log->actor_role === 'owner') bg-purple-100 text-purple-800
                                @elseif($log->actor_role === 'manager') bg-blue-100 text-blue-800
                                @else bg-green-100 text-green-800
                                @endif">
                                {{ ucfirst($log->actor_role) }}
                            </span>
                        </td>
                        <td class="px-4 py-3 text-sm">{{ $log->action_type }}</td>
                        <td class="px-4 py-3 text-sm">
                            {{ $log->subject_type ? class_basename($log->subject_type) : 'N/A' }}
                            @if($log->subject_id)#{{ $log->subject_id }}@endif
                        </td>
                        <td class="px-4 py-3 text-sm">{{ Str::limit($log->description ?? 'N/A', 50) }}</td>
                        <td class="px-4 py-3 text-xs text-gray-500">{{ $log->ip_address ?? 'N/A' }}</td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="7" class="text-center py-8 text-gray-600">No logs found</td>
                    </tr>
                @endforelse
            </tbody>
        </table>
    </div>

    <!-- Pagination -->
    <div class="mt-6">
        {{ $logs->links() }}
    </div>
</div>
@endsection