<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Setting;

class SettingsSeeder extends Seeder
{
    public function run(): void
    {
        $settings = [
            ['key' => 'site_name', 'value' => 'ShortStayNG', 'type' => 'string', 'group' => 'branding'],
            ['key' => 'site_description', 'value' => 'Your trusted platform for booking hotels and shortlets across Nigeria', 'type' => 'string', 'group' => 'branding'],
            ['key' => 'global_commission_percentage', 'value' => '15', 'type' => 'decimal', 'group' => 'financial'],
            ['key' => 'contact_email', 'value' => 'support@shortstayng.com', 'type' => 'string', 'group' => 'contact'],
            ['key' => 'contact_phone', 'value' => '+234 800 000 0000', 'type' => 'string', 'group' => 'contact'],
            ['key' => 'whatsapp_number', 'value' => '+234 800 000 0000', 'type' => 'string', 'group' => 'contact'],
            ['key' => 'contact_address', 'value' => 'Lagos, Nigeria', 'type' => 'string', 'group' => 'contact'],
            ['key' => 'facebook_url', 'value' => 'https://facebook.com/shortstayng', 'type' => 'string', 'group' => 'social'],
            ['key' => 'instagram_url', 'value' => 'https://instagram.com/shortstayng', 'type' => 'string', 'group' => 'social'],
            ['key' => 'linkedin_url', 'value' => 'https://linkedin.com/company/shortstayng', 'type' => 'string', 'group' => 'social'],
            ['key' => 'youtube_url', 'value' => '', 'type' => 'string', 'group' => 'social'],
        ];

        foreach ($settings as $setting) {
            Setting::updateOrCreate(
                ['key' => $setting['key']],
                $setting
            );
        }
    }
}
