<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\PromoBanner;

class PromoBannerSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        PromoBanner::create([
            'title' => 'Weekend Special! 🎉',
            'description' => 'Get up to 25% OFF on weekend bookings',
            'discount_code' => 'WEEKEND25',
            'discount_text' => '25% OFF',
            'button_text' => 'Browse Deals',
            'button_link' => '/properties',
            'background_color_from' => 'orange-500',
            'background_color_to' => 'red-500',
            'icon' => 'gift',
            'is_active' => true,
            'display_order' => 1,
            'start_date' => now(),
            'end_date' => now()->addDays(30),
        ]);

        PromoBanner::create([
            'title' => 'New Year Mega Sale! 🎊',
            'description' => 'Book now and save big on your next vacation',
            'discount_code' => 'NEWYEAR2025',
            'discount_text' => 'Save up to ₦50,000',
            'button_text' => 'Explore Properties',
            'button_link' => '/properties',
            'background_color_from' => 'purple-600',
            'background_color_to' => 'blue-600',
            'icon' => 'star',
            'is_active' => false,
            'display_order' => 2,
            'start_date' => null,
            'end_date' => null,
        ]);

        PromoBanner::create([
            'title' => 'Summer Getaway Special! ☀️',
            'description' => 'Enjoy exclusive discounts on beach properties',
            'discount_code' => 'SUMMER2025',
            'discount_text' => '30% OFF',
            'button_text' => 'View Beach Properties',
            'button_link' => '/properties?amenities=beach',
            'background_color_from' => 'cyan-500',
            'background_color_to' => 'blue-500',
            'icon' => 'umbrella-beach',
            'is_active' => false,
            'display_order' => 3,
            'start_date' => null,
            'end_date' => null,
        ]);
    }
}
