<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\KycFormField;

class KycFormFieldsSeeder extends Seeder
{
    /**
     * Run the database seeder.
     */
    public function run(): void
    {
        $fields = [
            // Business Information
            [
                'field_name' => 'business_name',
                'field_label' => 'Business/Company Name',
                'field_type' => 'text',
                'is_required' => true,
                'order' => 1,
                'placeholder' => 'Enter your business name',
                'help_text' => 'Official registered business name',
                'validation_rules' => 'required|string|max:255',
            ],
            [
                'field_name' => 'business_address',
                'field_label' => 'Business Address',
                'field_type' => 'textarea',
                'is_required' => true,
                'order' => 2,
                'placeholder' => 'Enter complete business address',
                'help_text' => 'Full physical address of your business',
                'validation_rules' => 'required|string|max:500',
            ],
            [
                'field_name' => 'business_registration_number',
                'field_label' => 'CAC Registration Number',
                'field_type' => 'text',
                'is_required' => false,
                'order' => 3,
                'placeholder' => 'RC Number',
                'help_text' => 'Corporate Affairs Commission registration number',
                'validation_rules' => 'nullable|string|max:100',
            ],
            [
                'field_name' => 'tax_identification_number',
                'field_label' => 'Tax Identification Number (TIN)',
                'field_type' => 'text',
                'is_required' => false,
                'order' => 4,
                'placeholder' => 'Enter TIN',
                'help_text' => 'Federal Inland Revenue Service TIN',
                'validation_rules' => 'nullable|string|max:100',
            ],
            
            // ID Information
            [
                'field_name' => 'id_type',
                'field_label' => 'ID Type',
                'field_type' => 'select',
                'field_options' => [
                    'national_id' => 'National ID Card',
                    'drivers_license' => "Driver's License",
                    'international_passport' => 'International Passport',
                    'voters_card' => "Voter's Card",
                ],
                'is_required' => true,
                'order' => 5,
                'help_text' => 'Select your identification document type',
                'validation_rules' => 'required|in:national_id,drivers_license,international_passport,voters_card',
            ],
            [
                'field_name' => 'id_number',
                'field_label' => 'ID Number',
                'field_type' => 'text',
                'is_required' => true,
                'order' => 6,
                'placeholder' => 'Enter ID number',
                'help_text' => 'Number on your identification document',
                'validation_rules' => 'required|string|max:100',
            ],
            
            // Bank Information
            [
                'field_name' => 'bank_name',
                'field_label' => 'Bank Name',
                'field_type' => 'text',
                'is_required' => true,
                'order' => 7,
                'placeholder' => 'e.g., Access Bank, GTBank',
                'help_text' => 'Name of your bank',
                'validation_rules' => 'required|string|max:100',
            ],
            [
                'field_name' => 'account_number',
                'field_label' => 'Account Number',
                'field_type' => 'text',
                'is_required' => true,
                'order' => 8,
                'placeholder' => '10-digit account number',
                'help_text' => 'Your bank account number for payouts',
                'validation_rules' => 'required|string|max:20',
            ],
            [
                'field_name' => 'account_name',
                'field_label' => 'Account Name',
                'field_type' => 'text',
                'is_required' => true,
                'order' => 9,
                'placeholder' => 'Account holder name',
                'help_text' => 'Name as it appears on your bank account',
                'validation_rules' => 'required|string|max:255',
            ],
            
            // Contact Information
            [
                'field_name' => 'contact_phone',
                'field_label' => 'Contact Phone Number',
                'field_type' => 'tel',
                'is_required' => true,
                'order' => 10,
                'placeholder' => '+234 XXX XXX XXXX',
                'help_text' => 'Primary contact number',
                'validation_rules' => 'required|string|max:20',
            ],
            [
                'field_name' => 'contact_email',
                'field_label' => 'Contact Email',
                'field_type' => 'email',
                'is_required' => true,
                'order' => 11,
                'placeholder' => 'email@example.com',
                'help_text' => 'Business email address',
                'validation_rules' => 'required|email|max:255',
            ],
            
            // Documents
            [
                'field_name' => 'id_document',
                'field_label' => 'ID Document (Upload)',
                'field_type' => 'file',
                'is_required' => true,
                'order' => 12,
                'help_text' => 'Upload a clear copy of your ID (PDF or Image)',
                'validation_rules' => 'required|file|mimes:pdf,jpg,jpeg,png|max:5120',
            ],
            [
                'field_name' => 'business_certificate',
                'field_label' => 'CAC Certificate (Upload)',
                'field_type' => 'file',
                'is_required' => false,
                'order' => 13,
                'help_text' => 'Upload CAC registration certificate if available',
                'validation_rules' => 'nullable|file|mimes:pdf,jpg,jpeg,png|max:5120',
            ],
        ];

        foreach ($fields as $field) {
            KycFormField::create($field);
        }
    }
}
