<?php

namespace Database\Seeders;

use App\Models\CarCategory;
use Illuminate\Database\Seeder;

class CarCategorySeeder extends Seeder
{
    public function run(): void
    {
        $categories = [
            [
                'name' => 'Economy',
                'slug' => 'economy',
                'description' => 'Affordable and fuel-efficient cars perfect for city driving',
                'icon' => 'fa-car-side',
                'order' => 1,
            ],
            [
                'name' => 'Compact',
                'slug' => 'compact',
                'description' => 'Small cars ideal for easy parking and maneuvering',
                'icon' => 'fa-car',
                'order' => 2,
            ],
            [
                'name' => 'Sedan',
                'slug' => 'sedan',
                'description' => 'Comfortable mid-size cars for business and family trips',
                'icon' => 'fa-car-side',
                'order' => 3,
            ],
            [
                'name' => 'SUV',
                'slug' => 'suv',
                'description' => 'Spacious vehicles perfect for families and group travel',
                'icon' => 'fa-truck-pickup',
                'order' => 4,
            ],
            [
                'name' => 'Luxury',
                'slug' => 'luxury',
                'description' => 'Premium vehicles with top-tier comfort and features',
                'icon' => 'fa-gem',
                'order' => 5,
            ],
            [
                'name' => 'Van/Minibus',
                'slug' => 'van-minibus',
                'description' => 'Large vehicles for group transportation',
                'icon' => 'fa-van-shuttle',
                'order' => 6,
            ],
            [
                'name' => 'Sports Car',
                'slug' => 'sports-car',
                'description' => 'High-performance vehicles for an exciting drive',
                'icon' => 'fa-car-burst',
                'order' => 7,
            ],
            [
                'name' => 'Electric',
                'slug' => 'electric',
                'description' => 'Eco-friendly electric and hybrid vehicles',
                'icon' => 'fa-charging-station',
                'order' => 8,
            ],
        ];

        foreach ($categories as $category) {
            CarCategory::updateOrCreate(
                ['slug' => $category['slug']],
                $category
            );
        }
    }
}
