<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::table('vendors', function (Blueprint $table) {
            // Property rental business verification
            $table->boolean('business_verified')->default(false)->after('cac_document');
            $table->json('business_verification_data')->nullable()->after('business_verified');
            $table->timestamp('business_verified_at')->nullable()->after('business_verification_data');
            
            // Car rental business verification
            $table->boolean('car_rental_business_verified')->default(false)->after('car_rental_account_name');
            $table->json('car_rental_verification_data')->nullable()->after('car_rental_business_verified');
            $table->timestamp('car_rental_business_verified_at')->nullable()->after('car_rental_verification_data');
        });
    }

    public function down()
    {
        Schema::table('vendors', function (Blueprint $table) {
            $table->dropColumn([
                'business_verified',
                'business_verification_data',
                'business_verified_at',
                'car_rental_business_verified',
                'car_rental_verification_data',
                'car_rental_business_verified_at',
            ]);
        });
    }
};
