<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('kyc_form_fields', function (Blueprint $table) {
            $table->id();
            $table->string('field_name'); // e.g., 'business_name', 'tax_id'
            $table->string('field_label'); // Display label
            $table->enum('field_type', ['text', 'textarea', 'select', 'file', 'number', 'email', 'tel']);
            $table->text('field_options')->nullable(); // JSON for select options
            $table->boolean('is_required')->default(false);
            $table->integer('order')->default(0);
            $table->boolean('is_active')->default(true);
            $table->string('placeholder')->nullable();
            $table->string('help_text')->nullable();
            $table->string('validation_rules')->nullable(); // e.g., 'max:255|min:3'
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('kyc_form_fields');
    }
};
