<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('bookings', function (Blueprint $table) {
            $table->enum('refund_payout_status', ['pending', 'requested', 'processing', 'paid'])->default('pending')->after('caution_refunded_at');
            $table->timestamp('refund_requested_at')->nullable()->after('refund_payout_status');
            $table->timestamp('refund_paid_at')->nullable()->after('refund_requested_at');
            $table->string('refund_payment_method')->nullable()->after('refund_paid_at');
            $table->text('refund_payment_details')->nullable()->after('refund_payment_method');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('bookings', function (Blueprint $table) {
            $table->dropColumn([
                'refund_payout_status',
                'refund_requested_at',
                'refund_paid_at',
                'refund_payment_method',
                'refund_payment_details',
            ]);
        });
    }
};
