<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // MySQL doesn't support modifying ENUM directly, so we need to use raw SQL
        DB::statement("ALTER TABLE car_bookings MODIFY COLUMN deposit_status ENUM('held', 'pending_inspection', 'dispute_pending', 'refunded', 'deducted', 'partially_deducted') DEFAULT 'held'");
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        DB::statement("ALTER TABLE car_bookings MODIFY COLUMN deposit_status ENUM('held', 'refunded', 'deducted') DEFAULT 'held'");
    }
};
