<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('vendors', function (Blueprint $table) {
            // Service Type
            $table->json('service_types')->nullable()->after('whatsapp_number'); // ['property', 'car_rental']
            
            // Car Rental Specific KYC
            $table->string('car_rental_business_name')->nullable();
            $table->string('car_rental_business_registration')->nullable(); // CAC number
            $table->string('car_rental_business_certificate')->nullable(); // Upload
            $table->string('car_rental_license')->nullable(); // Transport/rental license
            $table->string('car_rental_insurance_certificate')->nullable();
            $table->text('car_rental_business_address')->nullable();
            $table->string('car_rental_tax_id')->nullable(); // TIN
            
            // Bank Details for Car Rental (separate from property)
            $table->string('car_rental_bank_name')->nullable();
            $table->string('car_rental_account_number')->nullable();
            $table->string('car_rental_account_name')->nullable();
            
            // Verification Status
            $table->enum('car_rental_kyc_status', ['pending', 'verified', 'rejected'])->nullable();
            $table->text('car_rental_rejection_reason')->nullable();
            $table->timestamp('car_rental_verified_at')->nullable();
        });
    }

    public function down(): void
    {
        Schema::table('vendors', function (Blueprint $table) {
            $table->dropColumn([
                'service_types',
                'car_rental_business_name',
                'car_rental_business_registration',
                'car_rental_business_certificate',
                'car_rental_license',
                'car_rental_insurance_certificate',
                'car_rental_business_address',
                'car_rental_tax_id',
                'car_rental_bank_name',
                'car_rental_account_number',
                'car_rental_account_name',
                'car_rental_kyc_status',
                'car_rental_rejection_reason',
                'car_rental_verified_at',
            ]);
        });
    }
};
