<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('car_reviews', function (Blueprint $table) {
            $table->id();
            $table->foreignId('car_id')->constrained()->onDelete('cascade');
            $table->foreignId('car_booking_id')->constrained()->onDelete('cascade');
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            
            // Ratings (1-5)
            $table->integer('overall_rating');
            $table->integer('cleanliness_rating')->nullable();
            $table->integer('comfort_rating')->nullable();
            $table->integer('value_rating')->nullable();
            $table->integer('condition_rating')->nullable();
            
            // Review
            $table->text('comment')->nullable();
            $table->json('photos')->nullable();
            
            // Status
            $table->boolean('is_approved')->default(false);
            $table->timestamp('approved_at')->nullable();
            
            $table->timestamps();
            
            // Ensure one review per booking
            $table->unique('car_booking_id');
            $table->index(['car_id', 'is_approved']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('car_reviews');
    }
};
