<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('house_type_images', function (Blueprint $table) {
            $table->id();
            $table->string('house_type')->unique(); // Apartment, Villa, etc.
            $table->string('image'); // Image path
            $table->text('description')->nullable(); // Optional description
            $table->boolean('active')->default(true); // Show/hide
            $table->timestamps();
            
            $table->index('house_type');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('house_type_images');
    }
};
