<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('vendor_ads', function (Blueprint $table) {
            $table->foreignId('promo_code_id')->nullable()->after('payment_status')->constrained('promo_codes')->onDelete('set null');
            $table->string('promo_code')->nullable()->after('promo_code_id');
            $table->decimal('discount_amount', 10, 2)->default(0)->after('promo_code');
            $table->decimal('final_amount', 10, 2)->nullable()->after('discount_amount');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('vendor_ads', function (Blueprint $table) {
            $table->dropForeign(['promo_code_id']);
            $table->dropColumn(['promo_code_id', 'promo_code', 'discount_amount', 'final_amount']);
        });
    }
};
