<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('vendor_ads', function (Blueprint $table) {
            $table->string('payment_method')->nullable()->after('payment_reference');
            $table->string('payment_proof')->nullable()->after('payment_method');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('vendor_ads', function (Blueprint $table) {
            $table->dropColumn(['payment_method', 'payment_proof']);
        });
    }
};
