<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('bookings', function (Blueprint $table) {
            $table->enum('booking_status', ['pending', 'pending_payment', 'confirmed', 'cancelled', 'completed', 'checked_in'])->default('pending')->change();
            $table->string('payment_proof')->nullable()->after('payment_reference');
            $table->text('payment_notes')->nullable()->after('payment_proof');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('bookings', function (Blueprint $table) {
            $table->enum('booking_status', ['pending', 'confirmed', 'cancelled', 'completed'])->default('pending')->change();
            $table->dropColumn(['payment_proof', 'payment_notes']);
        });
    }
};
