<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('vendors', function (Blueprint $table) {
            // KYC Documents
            $table->string('id_card_type')->nullable()->after('verified'); // NIN, Driver's License, Passport, etc.
            $table->string('id_card_number')->nullable();
            $table->string('id_card_document')->nullable(); // File path
            $table->string('cac_document')->nullable(); // CAC/Business registration
            $table->string('business_address')->nullable();
            $table->string('home_address')->nullable();
            
            // KYC Status
            $table->enum('kyc_status', ['pending', 'approved', 'rejected'])->default('pending');
            $table->text('kyc_rejection_reason')->nullable();
            $table->timestamp('kyc_submitted_at')->nullable();
            $table->timestamp('kyc_approved_at')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('vendors', function (Blueprint $table) {
            $table->dropColumn([
                'id_card_type',
                'id_card_number',
                'id_card_document',
                'cac_document',
                'business_address',
                'home_address',
                'kyc_status',
                'kyc_rejection_reason',
                'kyc_submitted_at',
                'kyc_approved_at',
            ]);
        });
    }
};
