<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('transactions', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->nullable()->constrained()->nullOnDelete();
            $table->foreignId('vendor_id')->nullable()->constrained()->nullOnDelete();
            $table->foreignId('booking_id')->nullable()->constrained()->nullOnDelete();
            
            $table->string('type'); // booking_payment, ad_payment, refund, payout, commission
            $table->string('reference')->unique();
            $table->decimal('amount', 15, 2);
            $table->string('currency')->default('NGN');
            $table->enum('status', ['pending', 'completed', 'failed', 'cancelled'])->default('pending');
            
            $table->string('payment_method')->nullable(); // paystack, flutterwave
            $table->string('payment_gateway_reference')->nullable();
            $table->json('gateway_response')->nullable();
            
            $table->text('description')->nullable();
            $table->json('metadata')->nullable();
            
            $table->timestamps();
            
            $table->index('reference');
            $table->index(['user_id', 'type']);
            $table->index(['vendor_id', 'type']);
            $table->index('status');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('transactions');
    }
};