
<?php

// database/migrations/2024_01_01_000007_create_reviews_table.php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('reviews', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->foreignId('property_id')->constrained()->onDelete('cascade');
            $table->foreignId('booking_id')->constrained()->onDelete('cascade');
            
            $table->integer('rating'); // 1-5
            $table->text('comment')->nullable();
            
            // Individual ratings
            $table->integer('cleanliness_rating')->nullable();
            $table->integer('accuracy_rating')->nullable();
            $table->integer('checkin_rating')->nullable();
            $table->integer('communication_rating')->nullable();
            $table->integer('location_rating')->nullable();
            $table->integer('value_rating')->nullable();
            
            $table->boolean('visible')->default(true);
            $table->boolean('moderated')->default(false);
            $table->foreignId('moderated_by')->nullable()->constrained('users')->nullOnDelete();
            $table->timestamp('moderated_at')->nullable();
            $table->text('moderation_reason')->nullable();
            
            $table->timestamps();
            $table->softDeletes();
            
            $table->unique(['user_id', 'booking_id']);
            $table->index(['property_id', 'visible']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('reviews');
    }
};