<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('caution_refund_logs', function (Blueprint $table) {
            $table->id();
            $table->foreignId('booking_id')->constrained()->onDelete('cascade');
            $table->foreignId('actor_id')->constrained('users')->onDelete('cascade');
            $table->string('actor_role'); // vendor, manager, admin
            $table->enum('action', ['approved', 'rejected', 'refunded', 'overridden']);
            $table->enum('previous_status', ['pending', 'approved', 'rejected', 'refunded'])->nullable();
            $table->enum('new_status', ['pending', 'approved', 'rejected', 'refunded']);
            $table->text('reason')->nullable();
            $table->decimal('amount', 10, 2);
            $table->timestamps();
            
            $table->index('booking_id');
            $table->index('actor_id');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('caution_refund_logs');
    }
};