<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('activity_logs', function (Blueprint $table) {
            $table->id();
            $table->foreignId('actor_id')->constrained('users')->onDelete('cascade');
            $table->string('actor_role'); // owner, manager, moderator, vendor, user
            $table->string('action_type'); // created, updated, deleted, approved, rejected, etc.
            $table->string('subject_type')->nullable(); // booking, property, vendor, etc.
            $table->unsignedBigInteger('subject_id')->nullable();
            $table->json('details')->nullable(); // Additional context
            $table->text('description')->nullable();
            $table->ipAddress('ip_address')->nullable();
            $table->text('user_agent')->nullable();
            $table->timestamps();
            
            $table->index(['actor_id', 'actor_role']);
            $table->index(['subject_type', 'subject_id']);
            $table->index('action_type');
            $table->index('created_at');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('activity_logs');
    }
};