<?php

namespace App\Traits;

use App\Models\ActivityLog;

trait LogsActivity
{
    public static function bootLogsActivity(): void
    {
        static::created(function ($model) {
            $model->logActivity('created');
        });

        static::updated(function ($model) {
            $model->logActivity('updated');
        });

        static::deleted(function ($model) {
            $model->logActivity('deleted');
        });
    }

    public function logActivity(string $actionType, ?string $description = null): void
    {
        if (!auth()->check() || !auth()->user()->isAdmin()) {
            return;
        }

        ActivityLog::create([
            'actor_id' => auth()->id(),
            'actor_role' => auth()->user()->getRoleNames()->first(),
            'action_type' => $actionType,
            'subject_type' => get_class($this),
            'subject_id' => $this->id,
            'description' => $description ?? "{$actionType} " . class_basename($this),
            'details' => $this->getChanges(),
            'ip_address' => request()->ip(),
            'user_agent' => request()->userAgent(),
        ]);
    }
}