<?php

namespace App\Services\Notification;

class WhatsAppFactory
{
    public static function create(): WhatsAppServiceInterface
    {
        $driver = config('services.whatsapp.driver', 'twilio');
        
        return match($driver) {
            'twilio' => new TwilioWhatsAppService(),
            'business' => new WhatsAppBusinessService(),
            default => throw new \InvalidArgumentException("Unsupported WhatsApp driver: {$driver}"),
        };
    }
}