<?php

namespace App\Providers;

use Illuminate\Foundation\Support\Providers\EventServiceProvider as ServiceProvider;
use App\Events\BookingCreated;
use App\Events\BookingApproved;
use App\Events\PaymentVerified;
use App\Listeners\SendBookingNotification;
use App\Listeners\SendApprovalNotification;

class EventServiceProvider extends ServiceProvider
{
    protected $listen = [
        BookingCreated::class => [
            SendBookingNotification::class,
        ],
        BookingApproved::class => [
            SendApprovalNotification::class,
        ],
    ];

    public function boot(): void
    {
    }

    public function shouldDiscoverEvents(): bool
    {
        return false;
    }
}