<?php

namespace App\Providers;

use Illuminate\Foundation\Support\Providers\AuthServiceProvider as ServiceProvider;
use App\Models\Booking;
use App\Models\Property;
use App\Models\Vendor;
use App\Policies\BookingPolicy;
use App\Policies\PropertyPolicy;
use App\Policies\VendorPolicy;

class AuthServiceProvider extends ServiceProvider
{
    protected $policies = [
        Booking::class => BookingPolicy::class,
        Property::class => PropertyPolicy::class,
        Vendor::class => VendorPolicy::class,
    ];

    public function boot(): void
    {
        $this->registerPolicies();
    }
}