<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;
use App\Services\Notification\WhatsAppFactory;

class WhatsAppVerification extends Notification
{
    use Queueable;

    public function __construct(private string $code)
    {
    }

    public function via($notifiable): array
    {
        return ['whatsapp'];
    }

    public function toWhatsApp($notifiable): bool
    {
        $service = WhatsAppFactory::create();
        
        return $service->sendTemplate($notifiable->phone, 'verification', [
            'code' => $this->code,
        ]);
    }
}
