<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Review extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'user_id',
        'property_id',
        'booking_id',
        'rating',
        'comment',
        'cleanliness_rating',
        'accuracy_rating',
        'checkin_rating',
        'communication_rating',
        'location_rating',
        'value_rating',
        'visible',
        'moderated',
        'moderated_by',
        'moderated_at',
        'moderation_reason',
    ];

    protected $casts = [
        'visible' => 'boolean',
        'moderated' => 'boolean',
        'moderated_at' => 'datetime',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function property()
    {
        return $this->belongsTo(Property::class);
    }

    public function booking()
    {
        return $this->belongsTo(Booking::class);
    }

    public function moderatedBy()
    {
        return $this->belongsTo(User::class, 'moderated_by');
    }

    public function scopeVisible($query)
    {
        return $query->where('visible', true);
    }

    public function averageDetailedRating()
    {
        $ratings = [
            $this->cleanliness_rating,
            $this->accuracy_rating,
            $this->checkin_rating,
            $this->communication_rating,
            $this->location_rating,
            $this->value_rating,
        ];

        $validRatings = array_filter($ratings);
        
        return count($validRatings) > 0 ? array_sum($validRatings) / count($validRatings) : 0;
    }
}
