<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Language extends Model
{
    protected $fillable = [
        'name',
        'code',
        'flag',
        'is_active',
        'is_default',
        'is_rtl',
    ];

    protected $casts = [
        'is_active' => 'boolean',
        'is_default' => 'boolean',
        'is_rtl' => 'boolean',
    ];

    /**
     * Get active languages
     */
    public static function active()
    {
        return self::where('is_active', true)->orderBy('name')->get();
    }

    /**
     * Get default language
     */
    public static function default()
    {
        return self::where('is_default', true)->first();
    }
}
