<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class HouseTypeImage extends Model
{
    protected $fillable = [
        'house_type',
        'image',
        'description',
        'active',
    ];

    protected $casts = [
        'active' => 'boolean',
    ];

    /**
     * Get the number of properties of this house type
     */
    public function getPropertyCountAttribute()
    {
        return Property::active()->where('house_type', $this->house_type)->count();
    }

    /**
     * Scope for active house types
     */
    public function scopeActive($query)
    {
        return $query->where('active', true);
    }
}
