<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ActivityLog extends Model
{
    use HasFactory;

    protected $fillable = [
        'actor_id',
        'actor_role',
        'action_type',
        'subject_type',
        'subject_id',
        'details',
        'description',
        'ip_address',
        'user_agent',
    ];

    protected $casts = [
        'details' => 'array',
    ];

    public function actor()
    {
        return $this->belongsTo(User::class, 'actor_id');
    }

    public function subject()
    {
        return $this->morphTo();
    }

    public function scopeByRole($query, $role)
    {
        return $query->where('actor_role', $role);
    }

    public function scopeByActionType($query, $type)
    {
        return $query->where('action_type', $type);
    }
}