<?php

namespace App\Listeners;

use App\Events\BookingApproved;
use App\Notifications\BookingNotification;

class SendApprovalNotification
{
    public function handle(BookingApproved $event): void
    {
        $booking = $event->booking;
        
        // Notify user
        $booking->user->notify(new BookingNotification($booking, 'approved'));
    }
}
