<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;
use App\Rules\ValidCaptcha as ValidCaptchaRule;

class ValidateCaptcha
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        // Only validate on POST requests (form submissions)
        if ($request->isMethod('post')) {
            $request->validate([
                'captcha' => ['required', new ValidCaptchaRule()],
            ]);
        }
        
        return $next($request);
    }
}
