<?php

namespace App\Http\Controllers\User;

use App\Http\Controllers\Controller;
use App\Models\Favorite;
use App\Models\Property;
use Illuminate\Http\Request;

class FavoriteController extends Controller
{
    public function index()
    {
        $favorites = auth()->user()->favoriteProperties()
            ->with('vendor')
            ->where('status', 'active')
            ->paginate(12);

        return view('user.favorites.index', compact('favorites'));
    }

    public function toggle(Property $property)
    {
        $user = auth()->user();
        
        $favorite = Favorite::where('user_id', $user->id)
            ->where('property_id', $property->id)
            ->first();

        if ($favorite) {
            // Remove from favorites
            $favorite->delete();
            return response()->json([
                'success' => true,
                'favorited' => false,
                'message' => 'Removed from favorites'
            ]);
        } else {
            // Add to favorites
            Favorite::create([
                'user_id' => $user->id,
                'property_id' => $property->id,
            ]);
            return response()->json([
                'success' => true,
                'favorited' => true,
                'message' => 'Added to favorites'
            ]);
        }
    }
}
