<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Session;
use App\Models\Language;

class LanguageController extends Controller
{
    /**
     * Switch language
     */
    public function switch(Request $request, $code)
    {
        // Verify language exists and is active
        $language = Language::where('code', $code)
            ->where('is_active', true)
            ->first();

        if (!$language) {
            return redirect()->back()->with('error', 'Language not available');
        }

        // Store language in session
        Session::put('locale', $code);
        
        // Set application locale
        App::setLocale($code);

        return redirect()->back()->with('success', 'Language changed successfully');
    }
}
