<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

class CaptchaController extends Controller
{
    public function generate()
    {
        $captcha = $this->generateCaptchaCode();
        session(['captcha' => $captcha]);
        
        return response()->json(['image' => $this->createCaptchaImage($captcha)]);
    }
    
    private function generateCaptchaCode($length = 6)
    {
        $characters = 'ABCDEFGHJKLMNPQRSTUVWXYZ23456789'; // Removed confusing characters
        $captcha = '';
        for ($i = 0; $i < $length; $i++) {
            $captcha .= $characters[rand(0, strlen($characters) - 1)];
        }
        return $captcha;
    }
    
    private function createCaptchaImage($code)
    {
        // Create image
        $width = 200;
        $height = 60;
        $image = imagecreatetruecolor($width, $height);
        
        // Colors
        $bgColor = imagecolorallocate($image, 240, 240, 240);
        $textColor = imagecolorallocate($image, 20, 109, 115); // Primary color
        $lineColor = imagecolorallocate($image, 200, 200, 200);
        $dotColor = imagecolorallocate($image, 180, 180, 180);
        
        // Fill background
        imagefilledrectangle($image, 0, 0, $width, $height, $bgColor);
        
        // Add random lines for noise
        for ($i = 0; $i < 3; $i++) {
            imageline($image, rand(0, $width), rand(0, $height), rand(0, $width), rand(0, $height), $lineColor);
        }
        
        // Add random dots for noise
        for ($i = 0; $i < 50; $i++) {
            imagesetpixel($image, rand(0, $width), rand(0, $height), $dotColor);
        }
        
        // Add text using built-in font
        $x = 30;
        for ($i = 0; $i < strlen($code); $i++) {
            $y = rand(15, 25);
            imagestring($image, 5, $x, $y, $code[$i], $textColor);
            $x += 25;
        }
        
        // Output as base64
        ob_start();
        imagepng($image);
        $imageData = ob_get_clean();
        imagedestroy($image);
        
        return 'data:image/png;base64,' . base64_encode($imageData);
    }
}
