<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use Illuminate\Auth\Events\Verified;
use Illuminate\Foundation\Auth\EmailVerificationRequest;
use Illuminate\Http\Request;

class VerificationController extends Controller
{
    /**
     * Show the email verification notice
     */
    public function show()
    {
        if (auth()->user()->hasVerifiedEmail()) {
            return redirect()->route('home')->with('success', 'Email already verified.');
        }
        
        return view('auth.verify');
    }
    
    /**
     * Handle the email verification via signed URL
     */
    public function verify(EmailVerificationRequest $request)
    {
        if ($request->user()->hasVerifiedEmail()) {
            return redirect()->route('home')->with('info', 'Email already verified.');
        }

        if ($request->user()->markEmailAsVerified()) {
            event(new Verified($request->user()));
        }

        return redirect()->route('home')->with('success', 'Email verified successfully!');
    }
    
    /**
     * Resend the email verification notification
     */
    public function resend(Request $request)
    {
        if ($request->user()->hasVerifiedEmail()) {
            return back()->with('info', 'Email already verified.');
        }

        $request->user()->sendEmailVerificationNotification();

        return back()->with('resent', true);
    }

    /**
     * Manual verification (only for local development)
     */
    public function manual()
    {
        // Only allow in local environment
        if (config('app.env') !== 'local') {
            abort(404);
        }

        $user = auth()->user();
        
        if (!$user->hasVerifiedEmail()) {
            $user->markEmailAsVerified();
            event(new Verified($user));
        }

        return redirect()->route('home')->with('success', 'Email verified successfully!');
    }
}