<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\ActivityLog;
use Illuminate\Http\Request;

class AuditLogController extends Controller
{
    public function index(Request $request)
    {
        $query = ActivityLog::with('actor')->latest();
        
        if ($request->filled('actor_role')) {
            $query->byRole($request->actor_role);
        }
        
        if ($request->filled('action_type')) {
            $query->byActionType($request->action_type);
        }
        
        if ($request->filled('actor_id')) {
            $query->where('actor_id', $request->actor_id);
        }
        
        if ($request->filled('date_from')) {
            $query->whereDate('created_at', '>=', $request->date_from);
        }
        
        if ($request->filled('date_to')) {
            $query->whereDate('created_at', '<=', $request->date_to);
        }
        
        $logs = $query->paginate(50);
        
        return view('admin.audit-logs', compact('logs'));
    }
}