<?php

namespace App\Helpers;

use App\Models\ActivityLog;

class ActivityLogger
{
    public static function log(
        string $actionType,
        string $description,
        $subject = null,
        array $details = []
    ): void {
        if (!auth()->check()) {
            return;
        }

        $user = auth()->user();
        
        ActivityLog::create([
            'actor_id' => $user->id,
            'actor_role' => $user->getRoleNames()->first() ?? 'user',
            'action_type' => $actionType,
            'subject_type' => $subject ? get_class($subject) : null,
            'subject_id' => $subject ? $subject->id : null,
            'description' => $description,
            'details' => $details,
            'ip_address' => request()->ip(),
            'user_agent' => request()->userAgent(),
        ]);
    }
}
