<?php

namespace App\Console;

use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;

class Kernel extends ConsoleKernel
{
    protected function schedule(Schedule $schedule): void
    {
        // Expire ads daily at midnight
        $schedule->command('ads:expire')->daily();
        
        // Clean up old verification codes
        $schedule->call(function () {
            \App\Models\User::whereNotNull('verification_code')
                ->where('verification_code_expires_at', '<', now())
                ->update([
                    'verification_code' => null,
                    'verification_code_expires_at' => null,
                ]);
        })->hourly();
        
        // Complete bookings that have ended
        $schedule->call(function () {
            \App\Models\Booking::where('booking_status', 'confirmed')
                ->whereDate('end_date', '<', now())
                ->update(['booking_status' => 'completed']);
        })->daily();
        
        // Clear expired nearby attractions cache
        $schedule->call(function () {
            \App\Models\NearbyAttractionsCache::where('expires_at', '<', now())->delete();
        })->daily();
    }

    protected function commands(): void
    {
        $this->load(__DIR__.'/Commands');
        require base_path('routes/console.php');
    }
}
