<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;

class FixBookingVisibilityFlags extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'bookings:fix-visibility';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Fix visibility flags for paid and confirmed bookings';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $this->info('Fixing visibility flags for paid bookings...');
        
        // Get all paid and confirmed bookings
        $bookings = \App\Models\Booking::where('payment_status', 'paid')
            ->where('booking_status', 'confirmed')
            ->get();
        
        $this->info("Found {$bookings->count()} paid bookings");
        
        $updated = 0;
        foreach ($bookings as $booking) {
            // Set visibility flags if not already set
            if (!$booking->vendor_visible_user_info || !$booking->user_visible_vendor_info || !$booking->map_visible) {
                $booking->update([
                    'vendor_visible_user_info' => true,
                    'user_visible_vendor_info' => true,
                    'map_visible' => true,
                ]);
                $updated++;
                $this->info("Updated booking #{$booking->id}");
            }
        }
        
        $this->info("Completed! Updated {$updated} bookings.");
        
        return 0;
    }
}
