<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\VendorAd;

class ExpireAds extends Command
{
    protected $signature = 'ads:expire';
    protected $description = 'Deactivate expired advertisement plans';

    public function handle(): int
    {
        $expiredAds = VendorAd::where('active', true)
            ->where('end_date', '<', now())
            ->get();

        foreach ($expiredAds as $ad) {
            $ad->update(['active' => false]);
            
            $ad->property->update([
                'featured_until' => null,
                'ad_plan_id' => null,
            ]);
        }

        $this->info("Expired {$expiredAds->count()} ads.");

        return Command::SUCCESS;
    }
}
