# 📧 Email Setup Guide for Password Reset

## ✅ Password Reset Implementation Complete!

The password reset functionality is now fully implemented. Emails are currently being **logged to file** for testing.

---

## 🔧 Current Configuration

**Mail Driver:** `log` (emails written to `storage/logs/laravel.log`)

This is perfect for local development and testing!

---

## 🧪 How to Test Password Reset

### **Step 1: Request Password Reset**
1. Visit: `http://127.0.0.1:8000/forgot-password`
2. Enter a valid user email
3. Click "Send Reset Link"

### **Step 2: Find Reset Link in Logs**
```bash
# View the log file
tail -100 storage/logs/laravel.log

# Or search for reset links
grep -A 20 "reset-password" storage/logs/laravel.log
```

### **Step 3: Copy and Use Reset Link**
The log will contain a link like:
```
http://127.0.0.1:8000/reset-password/TOKEN?email=user@example.com
```

Copy this link and paste it in your browser.

### **Step 4: Reset Password**
1. Enter new password
2. Confirm password
3. Submit
4. Login with new password

---

## 📧 Production Email Setup Options

### **Option 1: Mailtrap (Recommended for Development)**
Free email testing service

```env
MAIL_MAILER=smtp
MAIL_HOST=sandbox.smtp.mailtrap.io
MAIL_PORT=2525
MAIL_USERNAME=your_username
MAIL_PASSWORD=your_password
MAIL_ENCRYPTION=tls
MAIL_FROM_ADDRESS="noreply@shortstayng.com"
MAIL_FROM_NAME="ShortStayNG"
```

**Sign up:** https://mailtrap.io

### **Option 2: Gmail (Quick Testing)**
```env
MAIL_MAILER=smtp
MAIL_HOST=smtp.gmail.com
MAIL_PORT=587
MAIL_USERNAME=your-email@gmail.com
MAIL_PASSWORD=your-app-password
MAIL_ENCRYPTION=tls
MAIL_FROM_ADDRESS="your-email@gmail.com"
MAIL_FROM_NAME="ShortStayNG"
```

**Note:** Enable 2FA and generate App Password at: https://myaccount.google.com/apppasswords

### **Option 3: SendGrid (Production)**
100 emails/day free

```env
MAIL_MAILER=smtp
MAIL_HOST=smtp.sendgrid.net
MAIL_PORT=587
MAIL_USERNAME=apikey
MAIL_PASSWORD=your-sendgrid-api-key
MAIL_ENCRYPTION=tls
MAIL_FROM_ADDRESS="noreply@shortstayng.com"
MAIL_FROM_NAME="ShortStayNG"
```

**Sign up:** https://sendgrid.com

### **Option 4: Mailgun (Production)**
5,000 emails/month free

```env
MAIL_MAILER=mailgun
MAILGUN_DOMAIN=your-domain.mailgun.org
MAILGUN_SECRET=your-api-key
MAIL_FROM_ADDRESS="noreply@shortstayng.com"
MAIL_FROM_NAME="ShortStayNG"
```

**Sign up:** https://www.mailgun.com

---

## 🔄 After Changing Email Configuration

Always run:
```bash
php artisan config:clear
php artisan cache:clear
```

---

## 🐛 Troubleshooting

### **No email in logs?**
```bash
# Check if user exists
php artisan tinker
>>> App\Models\User::where('email', 'test@example.com')->exists()

# Check recent logs
tail -50 storage/logs/laravel.log
```

### **Create test user:**
```bash
php artisan tinker
>>> $user = App\Models\User::create([
    'name' => 'Test User',
    'email' => 'test@example.com',
    'password' => bcrypt('password123'),
    'email_verified_at' => now()
]);
>>> $user->assignRole('user');
```

### **Token expired?**
Tokens expire after 60 minutes. Request a new reset link.

---

## ✅ What's Implemented

- ✅ Forgot password page
- ✅ Reset password page
- ✅ Email sending (via Laravel Password Broker)
- ✅ Token generation and validation
- ✅ Secure password hashing
- ✅ Password confirmation
- ✅ Modern, beautiful UI
- ✅ Error handling
- ✅ Success messages

---

## 📝 Quick Commands

```bash
# Clear all caches
php artisan optimize:clear

# View logs in real-time
tail -f storage/logs/laravel.log

# Test email configuration
php artisan tinker
>>> Mail::raw('Test email', function($msg) { 
    $msg->to('test@example.com')->subject('Test'); 
});
```

---

**Your password reset system is production-ready!** 🎉

Just configure your preferred email service when you're ready to go live.
